"use client"
import Image from 'next/image'
import axios from 'axios'
import { useEffect, useState } from 'react';
import parse from 'html-react-parser';
import Link from 'next/link'
import Footer from '../../components/footer'
import Header from '../../components/header'
import '../../globals.css'
import 'bootstrap/dist/css/bootstrap.css'
import { useParams } from 'next/navigation'
import Loader from '../../components/loader';
import Head from 'next/head'
import { useRouter } from 'next/router';



const Home = ()=>{
const [data,setData]=useState()
const params = useParams()
const [loaded,setLoaded]= useState(false)
const router = useRouter();



async function getData(params) {
  if (params?.slug) {
    const dataResponse = await axios.get('https://pixelfcty.com/api/news?filters[slug][$eq]='+params['slug']+'&populate=deep')
    const data = dataResponse.data.data[0]
    if (!data) {
      router.push('/404')
    }
    setData(data)  
  }

}

useEffect(() => { 
  getData(params)
  setTimeout(() => {
    setLoaded(true)
  }, 1000);
}, [params])

  return (
    <>
            <Head>
      <title>Aljaber Holding |  {data?.attributes.title}</title>
    </Head>
    {!loaded?

        <Loader></Loader>
    :
    <main >
            <div className='companyPage'>
      <Header />
      </div>
      <div className="col-12 mt-15 text-center">
        <img className='newsImage' src={'https://pixelfcty.com'+ data['attributes']['picture']['data']['attributes']['url']} />
        <h3 className='mt-5'>{data['attributes']['title']}</h3>
      </div>

      <div className="container">
        <div className="row  ">
          <div className="col-md-12 ck-content">
            {data ?
              parse(data['attributes']['description'])
              : ''
            }
          </div>
        </div>
      </div>


          <Footer/>
    </main>
        }
        </>
  )
}




export default Home;